<?php session_start(); ?>

<!doctype html>
<html class="no-js" lang="zxx"><!-- InstanceBegin template="/Templates/Alpha.dwt" codeOutsideHTMLIsLocked="false" -->

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>The MEC - Medical Emergency Centre</title>
    <meta name="description" content="The M.E.C The Medical Emergency Centre">
    <meta name="keywords" content="Health care, cardiology, vascular surgery, arrythmia treatment, stroke, coronary, angiogram, vascular, cardiac, private hospital, barbados">
    <meta name="robots" content="INDEX,FOLLOW">

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!--==============================
	   Google Web Fonts
	============================== -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;700&family=Quicksand:wght@400;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">


    <!-- Favicons - Place favicon.ico in the root directory -->
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">

    <!--==============================
	    All CSS File
	============================== -->
    <!-- Bootstrap -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!-- <link rel="stylesheet" href="assets/css/app.min.css"> -->
    <!-- Fontawesome Icon -->
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <!-- Layerslider -->
    <link rel="stylesheet" href="assets/css/layerslider.min.css">
    <!-- jQuery DatePicker -->
    <link rel="stylesheet" href="assets/css/jquery.datetimepicker.min.css">
    <!-- Magnific Popup -->
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <!-- Slick Slider -->
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <!-- Animate CSS -->
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">

</head>

<body class="">


    <!--[if lte IE 9]>
    	<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->



    <!--********************************
   		Code Start From Here 
	******************************** -->




    <!--==============================
     Preloader
  ==============================-->
    <div class="preloader  ">
        <button class="vs-btn preloaderCls">Cancel Preloader </button>
        <div class="preloader-inner">
            <svg width="88px" height="108px" viewBox="0 0 54 64">
                <defs></defs>
                <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <path class="beat-loader" d="M0.5,38.5 L16,38.5 L19,25.5 L24.5,57.5 L31.5,7.5 L37.5,46.5 L43,38.5 L53.5,38.5" id="Path-2" stroke-width="2"></path>
                </g>
            </svg>
        </div>
    </div>
    <!--==============================
    Mobile Menu
  ============================== -->
    <div class="vs-menu-wrapper">
        <div class="vs-menu-area text-center">
            <button class="vs-menu-toggle"><i class="fal fa-times"></i></button>
            <div class="mobile-logo">
                <a href="index.php"><img src="assets/img/logo002.png" alt="Medixi"></a>
            </div>
            <form action="#" class="mobile-menu-form">
                <input type="text" class="form-control" placeholder="Search...">
                <button type="submit"><i class="fas fa-search"></i></button>
            </form>
            <div class="vs-mobile-menu">
                <ul>
                    <li class="menu-item-has-children">
                        <a href="index.php">Staff</a>
                        <ul class="sub-menu">
                            <li><a href="1doc.html">Doctors/Surgeons</a></li>
                            <li><a href="1sup.html">Support Personnel</a></li>



                        </ul>
                    </li>

                    <li class="menu-item-has-children">
                        <a href="index.php">Patients &amp; Visitors</a>
                        <ul class="sub-menu">

                            <li><a href="2vis.html">Visitor Guidelines</a></li>
                            <li><a href="index.php">Download Forms</a></li>
                            <li><a href="2bkapp.html">Book Appointment</a></li>
                            <li><a href="2pat.html">Patient Safety</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="3ser.html">Services</a>
                    </li>

                    <li>
                        <a href="6tes.html">Testimonials</a>
                    </li>
                    <li>
                        <a href="index.php">Blog</a>
                    </li>

                    <li class="menu-item-has-children">
                        <a href="#">About</a>
                        <ul class="sub-menu">
                            <li><a href="6contact.html">Contact Us</a></li>
                            <li><a href="6promo.html">Promo Video</a></li>
                            <li><a href="6wcu.html">Why Choose Us</a></li>
                            <li><a href="6news.html">MEC News</a></li>

                        </ul>
                    </li>

                </ul>
            </div>
        </div>
    </div>

    <!--==============================
    Popup Search Box
    ============================== -->
    <div class="popup-search-box d-none d-lg-block  ">
        <button class="searchClose border-theme text-theme"><i class="fal fa-times"></i></button>
        <form action="#">
            <input type="text" class="border-theme" placeholder="What are you looking for">
            <button type="submit"><i class="fal fa-search"></i></button>
        </form>
    </div>
    <!--==============================
        Header Area
    ==============================-->
    <header class="header-wrapper header-layout1">
        <!-- Header Top -->
        <div class="header-top bg-title py-2 d-none d-md-block">
            <div class="container custom-container py-1">
                <div class="row justify-content-center justify-content-xl-between">
                    <div class="col-auto">
                        <ul class="header-top-info list-unstyled m-0">
                            <li><i class="far fa-envelope"></i><a href="mailto:support@hospital.com" class="text-reset">care@mecchealth.com</a></li>
                            <li><i class="far fa-map-marker-alt"></i>#4 6th Avenue Bellville, St. Michael</li>
                            <li><i class="far fa-clock"></i>Mon - Fri: 8:00 am - 4:00 pm</li>
                        </ul>
                    </div>
                    <div class="col-auto d-none d-xl-block">
                        <ul class="head-top-links text-end">
                            <li>
                                <!-- Dropdown -->
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fal fa-globe"></i> English
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">
                                    <li><a href="#">French</a></li>
                                    <li><a href="#">Italian</a></li>
                                    <li><a href="#">Spanish</a></li>

                                </ul>
                            </li>
                            <li>
                                <ul class="header-social">
                                    <li>
                                        <a href="https://www.facebook.com/profile.php?id=61581669345073&rdid=OYDpd1D0FeBaz0AB&share_url=https%3A%2F%2Fwww.facebook.com%2Fshare%2F1A3FkY1oYc%2F" target="_blank" rel="noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="https://www.instagram.com/barbadoscardiologyclinic" target="_blank" rel="noopener noreferrer"><i class="fab fa-instagram-square"></i></a>
                                    </li>
                                    <li>
                                        <a href="https://www.google.com/maps/place/The+MEC+Inc/@13.0970665,-59.6043125,17z/data=!3m1!4b1!4m6!3m5!1s0x8c43f724f78e4141:0xf61061b3fbf77fa4!8m2!3d13.0970665!4d-59.6017322!16s%2Fg%2F11w81z4hfk?entry=ttu&g_ep=EgoyMDI1MTAxNC4wIKXMDSoASAFQAw%3D%3D" target="_blank" rel="noopener noreferrer"><i class="fab fa-google"></i></a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <button type="submit" class="header-search-btn searchBoxTggler">Search<i class="far fa-search"></i></button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- Sticky Active -->
        <div class="sticky-wrap">
            <div class="sticky-active">
                <!-- Header Main -->
                <div class="header-main">
                    <div class="container custom-container position-relative">
                        <div class="row align-items-center justify-content-between">
                            <div class="col-auto col-xl-3 col-xxl-auto d-flex">
                                <div class="header1-logo">
                                    <a href="index.php"><img src="assets/img/logo002.png" alt="Logo"></a>
                                </div>
                                <div class="d-none-xxxl header-call phone-box d-flex align-items-center">
                                    <a href="tel:66925682596" class="box-icon"><i class="fas fa-phone-alt"></i></a>
                                    <div class="media-body">
                                        <span class="fs-xs text-title">Call Anytime</span>
                                        <p class="h4 fw-bold lh-1 mb-0"><a href="tel:12466243278">+1 (246) 624-3278</a></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto col-xl-9 col-xxl-auto py-3 py-lg-0">
                                <div class="row  justify-content-xl-between justify-content-xxl-end align-items-center">
                                    <div class="col-auto">
                                        <nav class="main-menu menu-style1 d-none d-lg-block">
                                            <ul>


                                                <li class="menu-item-has-children">
                                                    <a href="">Staff</a>
                                                    <ul class="sub-menu">
                                                        <li><a href="1doc.html">Doctors/Surgeons</a></li>
                                                        <li><a href="1sup.html">Support Personnel</a></li>

                                                    </ul>
                                                </li>


                                                <li class="menu-item-has-children">
                                                    <a href="">Patients &amp; Visitors</a>
                                                    <ul class="sub-menu">
                                                        <li><a href="2vis.html">Visitor Guidelines</a></li>
                                                        <li><a href="index.php">Download Forms</a></li>
                                                        <li><a href="2bkapp.html">Book Appointment</a></li>
                                                        <li><a href="2pat.html">Patient Safety</a></li>
                                                    </ul>
                                                </li>

                                                <li>
                                                    <a href="3ser.html">Services</a>
                                                </li>

                                                <li>
                                                    <a href="6tes.html">Testimonials</a>
                                                </li>
                                                <li>
                                                    <a href="index.php">Blog</a>
                                                </li>


                                                <li class="menu-item-has-children">
                                                    <a href="">About</a>
                                                    <ul class="sub-menu">
                                                        <li><a href="6contact.html">Contact Us</a></li>
                                                        <li><a href="6promo.html">Promo Video</a></li>
                                                        <li><a href="6wcu.html">Why Choose Us</a></li>
                                                        <li><a href="6news.html">MEC News</a></li>

                                                    </ul>
                                                </li>
                                            </ul>
                                        </nav>
                                        <button class="vs-menu-toggle d-inline-block d-lg-none"><i class="fas fa-bars"></i></button>
                                    </div>
                                    <div class="col-auto d-none d-xl-block">
                                        <div class="header-btn">

                                            <a href="2bkapp.html" class="vs-btn style2">Appointment<i class="fal fa-calendar-alt"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-note  d-none d-xl-block">
            <div class="note-inner">
                <div class="container custom-container">
                    <p class="note-text"><span class="text-theme"><i class="fas fa-exclamation-circle me-2"></i>Notice:</span> &nbsp; We provide a range of Services and Care.<a href="3ser.html"> <u>See More </u></a></p>
                </div>
            </div>
        </div>
    </header>
    <!-- InstanceBeginEditable name="M1" --> <!--==============================
      Hero Area
    ==============================-->
    <section class="vs-hero-wrapper position-relative  ">
        <div class="vs-hero-carousel" data-navprevnext="true" data-height="800" data-container="1900" data-slidertype="responsive">
            <div class="ls-slide" data-ls="duration: 13000; transition2d: 5;">
                <img src="assets/img/hero/hp001.jpg" alt="Hero Image" class="ls-bg">
                <h1 class="text-title ls-l ls-responsive" data-ls-mobile="left: 100px; top: 120px; font-size: 120px;" data-ls-tablet="left: 100px; top: 80px; font-size: 92px;" data-ls-laptop="left: 100px; top: 120px; font-size: 82px;" style="left: 335px; top: 208px; font-size: 72px; font-weight: 700;" data-ls="delayin: 600; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">Welcome To The M.E.C</h1>
                <h1 class="text-white ls-l ls-responsive" data-ls-mobile="left: 100px;  top: 285px; font-size: 120px;" data-ls-tablet="left: 100px; top: 210px; font-size: 92px;" data-ls-laptop="left: 100px; top: 230px; font-size: 82px;" style="left: 335px; top: 290px; font-size: 65px; font-weight: 700;" data-ls="delayin: 0; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">MEDICAL EMERGENCY CENTRE</h1>
                <p class="ls-l text-white ls-responsive ls-hide-sm" data-ls-mobile="left: 100px; " data-ls-tablet=" left: 100px; top: 360px; font-size: 34px; width: 1000px; line-height: 52px;" data-ls-laptop="left: 100px; top: 380px; font-size: 26px; width: 800px; line-height: 48px;" style="left: 335px; top: 400px; width: 605px; font-size: 24px; font-weight: 400; white-space: normal; letter-spacing: 0.02em; line-height: 28px;" data-ls="delayin: 800; texttransitionin: true; textstartatin: transitioninstart; texttypein: lines_asc; textshiftin: 100; textoffsetyin: 100; textdurationin: 2000; offsetyout: 100; durationout: 2000; ">Your Comprehensive Cardiac Centre</p>
                <div class="ls-btn ls-l ls-responsive" data-ls-mobile="left: 100px; " data-ls-tablet="left: 100px; top: 580px;" data-ls-laptop="left: 100px; top: 580px;" style="left: 335px; top: 518px;" data-ls="offsetyin: 200; durationin: 2000; delayin: 1400; offsetyout: 300; durationout: 2000; offsetyout: 100; durationout: 2000; ">
                    <a href="3ser.html" class="vs-btn style3 hover-white">View All Services<i class="fas fa-bolt"></i></a>
                </div>
            </div>

            <div class="ls-slide" data-ls="duration: 13000; transition2d: 5;">
                <img src="assets/img/hero/hb04.jpg" alt="Hero Image" class="ls-bg">
                <h1 class="text-title ls-l ls-responsive" data-ls-mobile="left: 100px; top: 120px; font-size: 120px;" data-ls-tablet="left: 100px; top: 80px; font-size: 92px;" data-ls-laptop="left: 100px; top: 120px; font-size: 82px;" style="left: 335px; top: 208px; font-size: 72px; font-weight: 700;" data-ls="delayin: 600; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">Best Medics, Doctors</h1>
                <h1 class="text-white ls-l ls-responsive" data-ls-mobile="left: 100px;  top: 285px; font-size: 120px;" data-ls-tablet="left: 100px; top: 210px; font-size: 92px;" data-ls-laptop="left: 100px; top: 230px; font-size: 82px;" style="left: 335px; top: 290px; font-size: 72px; font-weight: 700;" data-ls="delayin: 0; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">and Surgeons</h1>
                <p class="ls-l text-white ls-responsive ls-hide-sm" data-ls-mobile="left: 100px; " data-ls-tablet=" left: 100px; top: 360px; font-size: 34px; width: 1000px; line-height: 52px;" data-ls-laptop="left: 100px; top: 380px; font-size: 26px; width: 800px; line-height: 48px;" style="left: 335px; top: 400px; width: 605px; font-size: 20px; font-weight: 400; white-space: normal; letter-spacing: 0.02em; line-height: 28px;" data-ls="delayin: 800; texttransitionin: true; textstartatin: transitioninstart; texttypein: lines_asc; textshiftin: 100; textoffsetyin: 100; textdurationin: 2000; offsetyout: 100; durationout: 2000; ">Your Lifeline For Cardiac Emergencies</p>
                <div class="ls-btn ls-l ls-responsive" data-ls-mobile="left: 100px; " data-ls-tablet="left: 100px; top: 580px;" data-ls-laptop="left: 100px; top: 580px;" style="left: 335px; top: 518px;" data-ls="offsetyin: 200; durationin: 2000; delayin: 1400; offsetyout: 300; durationout: 2000; offsetyout: 100; durationout: 2000; ">
                    <a href="3ser.html" class="vs-btn style3 hover-white">View All Services<i class="fas fa-bolt"></i></a>
                </div>
            </div>

            <div class="ls-slide" data-ls="duration: 13000; transition2d: 5;">
                <img src="assets/img/hero/hb06.jpg" alt="Hero Image" class="ls-bg">
                <h1 class="text-title ls-l ls-responsive" data-ls-mobile="left: 100px; top: 120px; font-size: 120px;" data-ls-tablet="left: 100px; top: 80px; font-size: 92px;" data-ls-laptop="left: 100px; top: 120px; font-size: 82px;" style="left: 335px; top: 208px; font-size: 72px; font-weight: 700;" data-ls="delayin: 600; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">Best Treatment for</h1>
                <h1 class="text-white ls-l ls-responsive" data-ls-mobile="left: 100px;  top: 285px; font-size: 120px;" data-ls-tablet="left: 100px; top: 210px; font-size: 92px;" data-ls-laptop="left: 100px; top: 230px; font-size: 82px;" style="left: 335px; top: 290px; font-size: 72px; font-weight: 700;" data-ls="delayin: 0; easingin: easeInOutSine; texttransitionin: true; textstartatin: transitioninstart; textdurationin: 2000; texttypein: words_asc; textshiftin: 200; textoffsetyin: -100; offsetyout: -100; durationout: 2000; ">healthy life</h1>
                <p class="ls-l text-white ls-responsive ls-hide-sm" data-ls-mobile="left: 100px; " data-ls-tablet=" left: 100px; top: 360px; font-size: 34px; width: 1000px; line-height: 52px;" data-ls-laptop="left: 100px; top: 380px; font-size: 26px; width: 800px; line-height: 48px;" style="left: 335px; top: 400px; width: 605px; font-size: 20px; font-weight: 400; white-space: normal; letter-spacing: 0.02em; line-height: 28px;" data-ls="delayin: 800; texttransitionin: true; textstartatin: transitioninstart; texttypein: lines_asc; textshiftin: 100; textoffsetyin: 100; textdurationin: 2000; offsetyout: 100; durationout: 2000; ">Conveniently access information &amp; help.</p>
                <div class="ls-btn ls-l ls-responsive" data-ls-mobile="left: 100px; " data-ls-tablet="left: 100px; top: 580px;" data-ls-laptop="left: 100px; top: 580px;" style="left: 335px; top: 518px;" data-ls="offsetyin: 200; durationin: 2000; delayin: 1400; offsetyout: 300; durationout: 2000; offsetyout: 100; durationout: 2000; ">
                    <a href="3ser.html" class="vs-btn style3 hover-white">View All Services<i class="fas fa-bolt"></i></a>
                </div>
            </div>
        </div>
    </section>
    <!--==============================
    About Area
    ==============================-->
    <section class="vs-about-wrapper space" data-bg-src="assets/img/bg/bg-shape-1.jpg">
        <div class="container">
            <div class="row ">
                <div class="col-lg-6 mb-30 mb-lg-0">
                    <div class="about-img1 wow fadeInUp" data-wow-delay="0.3s">
                        <img src="assets/img/about/A03.jpg" alt="About Image" class="w-100">

                    </div>
                </div>
                <div class="col-lg-6 align-self-center">
                    <div class="about-content ps-xl-5 ms-xl-2">
                        <h2 class="h1 mt-n2 mb-3 pb-1">Delivering Superior Cardiac Care<span class="text-theme">, every step of the way ...</span></h2>
                        <p class="mb-4">Our state-of-the art facility, is equipped with advanced technology and staffed by a dedicated team of medical professionals</p>
                        <div class="media-style1">
                            <div class="media-icon"><i class="fas fa-phone"></i></div>
                            <div class="media-body">
                                <h3 class="media-title">CALL ANYTIME 24/7</h3>
                                <p class="media-text"><a href="tel:+12466243278">+1 (246) 624-3278</a></p>
                            </div>
                        </div>
                        <a href="3ser.html" class="vs-btn">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="position-relative bg-box1">
        <div class="bg-box-shape1 position-absolute " data-overlay="title" data-opacity="7" data-bg-src="assets/img/bg/h001.jpg"></div>
        <div class="bg-box-shape2 position-absolute" data-bg-src="assets/img/bg/bg-shape-2.jpg"></div>
        <!--==============================
    Service Area
    ==============================-->
        <section class="vs-service-wrapper space">
            <div class="container">
                <div class="row  text-center justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-6 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="section-title">
                            <span class="h3 sec-subtitle text-theme">Cardiac &amp; Non Cardiac Care!</span>
                            <h2 class="h1 text-white">Expert Services</h2>

                            <p class="h2 text-white">“To provide cardiac treatment parallel to none in the Caribbean”</p>
                        </div>
                    </div>
                </div>
                <div class="row vs-carousel wow fadeInUp" data-wow-delay="0.3s" data-arrows="true" data-slide-show="3">
                    <div class="col-xl-4">
                        <div class="service-card mb-30">
                            <div class="sr-body">
                                <h3 class="h3 sr-title mb-2 mb-md-4"><a class="text-reset" href="1sup.html">Nurses</a></h3>
                                <p class="sr-text fs-xs">Nurses provide a crucial role during your most challenging times and critical moments. At the M.E.C we practice the perfect harmony of compassion, conviction and knowledge. </p>
                            </div>
                            <div class="sr-icons">
                                <a href="1sup.html" class="icon-btn style2"><i class="far fa-long-arrow-right"></i></a>
                                <span class="sr-icon"><i class="flaticon-medical-symbol fa-4x"></i></span>
                            </div>
                            <div class="sr-img">
                                <div class="position-absolute start-0 end-0 top-0"><img src="assets/img/bg/sr-shape.png" class="w-100" alt="Shape"></div>
                                <img class="w-100" src="assets/img/service/007.jpg" alt="Serivce Image">
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="service-card mb-30">
                            <div class="sr-body">
                                <h3 class="h3 sr-title mb-2 mb-md-4"><a class="text-reset" href="1doc.html">Cardiologists</a></h3>
                                <p class="sr-text fs-xs">&nbsp;With a focus on diagnosing and treating diseases of the heart and blood vessels, we offer a range of superior treatment options, to improve outcomes and surpass expectations.. </p>
                            </div>
                            <div class="sr-icons">
                                <a href="1doc.html" class="icon-btn style2"><i class="far fa-long-arrow-right"></i></a>
                                <span class="sr-icon"><i class="flaticon-healthcare fa-4x"></i></span>
                            </div>
                            <div class="sr-img">
                                <div class="position-absolute start-0 end-0 top-0"><img src="assets/img/bg/sr-shape.png" class="w-100" alt="Shape"></div>
                                <img class="w-100" src="assets/img/service/002.jpg" alt="Serivce Image">
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="service-card mb-30">
                            <div class="sr-body">
                                <h3 class="h3 sr-title mb-2 mb-md-4"><a class="text-reset" href="1doc.html">Surgeons</a></h3>
                                <p class="sr-text fs-xs">Our dedicated Surgeons with their individual skills and collective experience, offer advanced techniques. We are committed to providing the highest and safest level of patient care possible. </p>
                            </div>
                            <div class="sr-icons">
                                <a href="1doc.html" class="icon-btn style2"><i class="far fa-long-arrow-right"></i></a>
                                <span class="sr-icon"><i class="flaticon-group fa-4x"></i></span>
                            </div>
                            <div class="sr-img">
                                <div class="position-absolute start-0 end-0 top-0"><img src="assets/img/bg/sr-shape.png" class="w-100" alt="Shape"></div>
                                <img class="w-100" src="assets/img/service/003.jpg" alt="Serivce Image">
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="service-card mb-30">
                            <div class="sr-body">
                                <h3 class="h3 sr-title mb-2 mb-md-4"><a class="text-reset" href="2bkapp.html">Virtual Care</a></h3>
                                <p class="sr-text fs-xs">Remote Technology ... We provide convenient Tele-Health via remote connections. Excellent for patients who are not always able to manage in person meetings with health care providers. </p>
                            </div>
                            <div class="sr-icons">
                                <a href="2bkapp.html" class="icon-btn style2"><i class="far fa-long-arrow-right"></i></a>
                                <span class="sr-icon"><i class="flaticon-discuss fa-4x"></i></span>
                            </div>
                            <div class="sr-img">
                                <div class="position-absolute start-0 end-0 top-0"><img src="assets/img/bg/sr-shape.png" class="w-100" alt="Shape"></div>
                                <img class="w-100" src="assets/img/service/004.jpg" alt="Serivce Image">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center justify-content-lg-between align-items-center pt-30 no-pt-sm">
                    <div class="col-auto mb-30 mb-lg-0">
                        <div class="notice-bar fs-xs bg-white text-center">
                            <p><i class="fal fa-exclamation-circle text-theme me-2"></i> Delivering tomorrow’s health care for your family, today. </p>

                        </div>
                    </div>
                    <div class="col-auto">
                        <a href="index.php" class="vs-btn style2">Make Appointment<i class="far fa-calendar-alt"></i></a>
                    </div>
                </div>
            </div>
        </section>
        <!--==============================
    About Area
    ==============================-->
        <section class="vs-about-wrapper space-md-bottom">
            <div class="container">
                <div class="row flex-row-reverse">
                    <div class="col-xl-5 col-xxl-6 mb-30">
                        <div class="about-image wow fadeIn" data-wow-delay="0.3s">
                            <img src="assets/img/about/mn04.jpg" alt="About Image">
                        </div>
                    </div>
                    <div class="col-xl-7 col-xxl-6 align-self-center">
                        <span class="h3 text-theme sec-subtitle mb-2 mb-md-0">First Class Treatment &amp; Facilities</span>
                        <h2 class="h1">We care your loved ones</h2>
                        <p class="pe-xl-5">At The M.E.C, we specialise inth the evaluation and treatment of chest pain, ensuring rapid and effective care for patients with coronary artery disease. </p>
                        <div class="row pt-3">
                            <div class="col-sm-6 col-lg-5 col-xl-6">
                                <div class="d-flex mb-25">
                                    <span class="text-theme mr-20"><i class="flaticon-security fa-3x lh-1"></i></span>
                                    <div class="media-body">
                                        <h3 class="h5 mb-2 pb-1">100% Reliability</h3>
                                        <p class="mb-0 fs-xs">Dependability and consistency are basic principles at The M.E.C..</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-5 col-xl-6">
                                <div class="d-flex mb-25">
                                    <span class="text-theme mr-20"><i class="flaticon-computer-mouse fa-3x lh-1"></i></span>
                                    <div class="media-body">
                                        <h3 class="h5 mb-2 pb-1">Specialist Surgery </h3>
                                        <p class="mb-0 fs-xs">Experts in their field for your peace of mind..</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-5 col-xl-6">
                                <div class="d-flex mb-25">
                                    <span class="text-theme mr-20"><i class="flaticon-healthcare fa-3x lh-1"></i></span>
                                    <div class="media-body">
                                        <h3 class="h5 mb-2 pb-1">24/7 take care staff</h3>
                                        <p class="mb-0 fs-xs">Professional Services as needed for your convenience.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-5 col-xl-6">
                                <div class="d-flex mb-25">
                                    <span class="text-theme mr-20"><i class="flaticon-laboratory-equipment fa-3x lh-1"></i></span>
                                    <div class="media-body">
                                        <h3 class="h5 mb-2 pb-1">Medicine Service</h3>
                                        <p class="mb-0 fs-xs">Medication management and supply.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!--==============================
    Team Area
    ==============================-->
    <section class="vs-team-wrapper space-top space-md-bottom" data-bg-src="assets/img/bg/bg-02.jpg">
        <div class="container">
            <div class="row  text-center justify-content-center">
                <div class="col-md-10 col-lg-8 col-xl-6 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title">
                        <span class="h3 text-theme sec-subtitle">Medical &amp; General Attention!</span>
                        <h2 class="h1">Meet Our Doctors</h2>
                        <p>A collaborative team ... Committed to ensuring that you are able to live your best life.</p>
                    </div>
                </div>
            </div>
            <div class="row vs-carousel wow fadeIn" data-wow-delay="0.3s" data-arrows="true" data-slide-show="3" data-lg-slide-show="2">
                <div class="col-xl-4 mb-30">
                    <div class="team-card">
                        <div class="team-head">
                            <img src="assets/img/team/dr_heller.jpg" alt="Team Area" class="w-100">

                        </div>
                        <div class="team-body">
                            <h3 class="h4 mb-0">Dr. Heller</h3>
                            <p class="fs-xs degi text-theme mb-2">Interventional Cardiologist</p><br>

                            <p class="fs-xs">Thomas Jefferson University. Fellowship in Cardiovascular Disease - University of Massachusetts. Internal Medicine - Rutgers University. Medical School<br>
                                <br>

                            </p>
                            <div class="">
                                <p class="fs-xs team-info"><i class="fas fa-phone text-theme"></i><a class="text-reset" href="tel:12466243278">+1 (246) 624-3278</a></p>
                                <p class="fs-xs team-info"><i class="fas fa-envelope text-theme"></i><a class="text-reset" href="mailto:care@mecchealth.com">care@mecchealth.com</a></p>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="col-xl-4 mb-30">
                    <div class="team-card">
                        <div class="team-head">
                            <img src="assets/img/team/dr_sparman.jpg" alt="Team Area" class="w-100">

                        </div>
                        <div class="team-body">
                            <h3 class="h4 mb-0">Dr. Sparman</h3>
                            <p class="fs-xs degi text-theme mb-2">Interventional Cardiologist</p>
                            <p class="fs-xs"><br>
                                Shands Jacksonville Medical center, Fellowship in Cardiovascular Disease - Mount Sinai New York. Internal Medicine - New York Medical College. Medical School<br>
                                <br>

                            </p>
                            <div class="">
                                <p class="fs-xs team-info"><i class="fas fa-phone text-theme"></i><a class="text-reset" href="tel:12466243278">+1 (246) 624-3278</a></p>
                                <p class="fs-xs team-info"><i class="fas fa-envelope text-theme"></i><a class="text-reset" href="mailto:care@mecchealth.com">care@mecchealth.com</a></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 mb-30">
                    <div class="team-card">
                        <div class="team-head">
                            <img src="assets/img/team/dr-paresi00.jpg" alt="Team Area" class="w-100">

                        </div>
                        <div class="team-body">
                            <h3 class="h4 mb-0">Dr. Paresi</h3>
                            <p class="fs-xs degi text-theme mb-2">Plastic Surgeon</p>
                            <p class="fs-xs">Rush University Center. Fellowship in Plastic Surgery - Lennox Hill Hospital. Fellowship in Plastic Surgery - Rush University Cancer Center. Fellowship in Plastic Surgery - Monmouth Medical Center. Residency in General Surgery - St. George’s University. Medical School </p>
                            <div class="">
                                <p class="fs-xs team-info"><i class="fas fa-phone text-theme"></i><a class="text-reset" href="tel:12466243278">+1 (246) 624-3278</a></p>
                                <p class="fs-xs team-info"><i class="fas fa-envelope text-theme"></i><a class="text-reset" href="mailto:care@mecchealth.com">care@mecchealth.com</a></p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <div class="bg-box2 position-relative">
        <div class="bg-box-shape3 z-index-n1 position-absolute">
            <div class="parallax" data-parallax-image="assets/img/bg/team2-1.jpg"></div>
        </div>
        <!--==============================
    Skill Area
    ==============================-->
        <section class="vs-skill-wrapper  ">
            <div class="container">
                <div class="skill-wrap1 bg-white">
                    <div class="row justify-content-center justify-content-lg-between">
                        <div class="col-md-6 col-lg-auto  mb-30">
                            <div class="d-xl-flex text-center text-xl-start skill-box">
                                <span class="ripple-icon hover-style2  align-self-start mb-20 mb-xl-0 mr-20"><i class="flaticon-discuss"></i></span>
                                <div class="media-body">
                                    <h2 class="mt-n2 mb-0 text-theme">30+</h2>
                                    <p class="text-title fs-md fw-medium mt-1 mt-xl-0 mb-2 mb-xl-2">Years Of Experience</p>
                                    <p class="fs-xs mb-0">Our pool of knowledge ensures a wealth of proficiency and skills</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-auto  mb-30">
                            <div class="d-xl-flex text-center text-xl-start skill-box">
                                <span class="ripple-icon  hover-style2 align-self-start mb-20 mb-xl-0 mr-20"><i class="flaticon-medical-equipment"></i></span>
                                <div class="media-body">
                                    <h2 class="mt-n2 mb-0 text-theme">20+</h2>
                                    <p class="text-title fs-md fw-medium mt-1 mt-xl-0 mb-2 mb-xl-2">Experienced Doctor's</p>
                                    <p class="fs-xs mb-0">Our resources extend to consulting associates and specialist Doctors </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-auto  mb-30">
                            <div class="d-xl-flex text-center text-xl-start skill-box">
                                <span class="ripple-icon  hover-style2 align-self-start mb-20 mb-xl-0 mr-20"><i class="flaticon-healthcare"></i></span>
                                <div class="media-body">
                                    <h2 class="mt-n2 mb-0 text-theme">200+</h2>
                                    <p class="text-title fs-md fw-medium mt-1 mt-xl-0 mb-2 mb-xl-2">Happy Patients</p>
                                    <p class="fs-xs mb-0">A positive experience and excellent care is standard for all Patients</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--==============================
    Appointment Form Area 
    ==============================-->
        <section class="appointment-wrapper space-top space-bottom">
            <div class="container">
                <div class="row gx-0">
                    <div class="col-xl-6 align-self-end">
                        <div class="about-box1 bg-white">
                            <h2 class="h1 mb-3 pb-1">You will not regret <span class="text-theme">believing in us.</span></h2>
                            <p>Your Health Service is our top priority, our passion and our deepest concern. When a Patient assigns The MEC with their care, it is respected as a pledge of trust in us ... Every Case Matters. </p>
                            <div class="row pt-2 mt-3">
                                <div class="col-md-5 col-lg-4 col-xl-5">
                                    <ul class="about-list list-unstyled text-title mb-4 pb-1">
                                        <li>Blood Bank</li>
                                        <li>Medical Care</li>
                                    </ul>
                                </div>
                                <div class="col-md-5 col-lg-4 col-xl-5">
                                    <ul class="about-list list-unstyled text-title mb-4 pb-1">
                                        <li>Heart Transplant</li>
                                        <li>General Surgery</li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-xl-6 wow fadeInUp" data-wow-delay="0.3s">
                        <form action="sendemail.php" method="POST" class="form-wrap1 bg-white">
                            <div class="form-title-box bg-title" data-bg-src="assets/img/bg/bg-shape-11.jpg">
                                <div class="row justify-content-between align-items-center">
                                    <div class="col-auto">
                                        <h2 class="h4 mb-1 text-white">Book An Appointment</h2>
                                        <p class="mb-0 text-white-light">Please Call Us To Ensure</p>
                                    </div>
                                    <div class="col-auto d-none d-sm-block">
                                        <a href="tel:12466243278" class="ripple-icon style2"><i class="fas fa-phone"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="form-box">
                                <div class="row">
                                    <div class="col-xl-6 form-group">
                                        <select name="services" class="form-select style2">
                                            <option hidden disabled selected>Select Services</option>
                                            <option>General Inquiry</option>
                                            <option>Chest Pain</option>
                                            <option>Cardiology</option>
                                            <option>General Medicine</option>
                                            <option>Stroke Care</option>
                                            <option>Other</option>
                                        </select>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <select name="doctor" class="form-select style2">
                                            <option hidden disabled selected>Choose Doctor</option>
                                            <option>Dr. Heller</option>
                                            <option>Dr. Sparman</option>
                                            <option>Dr. Alejandro Gonzalez Veliz</option>
                                            <option>Dr. Susel Ramos Busutil</option>
                                            <option>Dr. Paresi</option>

                                        </select>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <input type="text" class="form-control  style2" placeholder="Your Name" name="full_name" />
                                        <i class="fal small fa-user"></i>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <input type="email" class="form-control  style2" placeholder="Email Address" name="email">
                                        <i class="fal small fa-envelope"></i>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <input type="number" class="form-control  style2" placeholder="Your Phone" name="phone">
                                        <i class="fal small fa-phone"></i>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <input type="text" class="dateTime-pick form-control  style2" placeholder="Select Date & Time" name="datetime" />
                                        <i class="fal small fa-calendar-alt"></i>
                                    </div>
                                    <div class="col-xl-12 text-center">
                                        <button type="submit" name="submitPatient" class=vs-btn style2">
                                            Make Appointment<i class="far fa-calendar-alt"></i></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!--==============================
    Testimonial Area
    ==============================-->
    <section class="testimonial-wrapper space-top">
        <div class="parallax" data-parallax-image="assets/img/bg/bg-shape-3.jpg"></div>
        <div class="container position-relative z-index-common">
            <div class="row  text-center justify-content-center">
                <div class="col-md-10 col-lg-8 col-xl-6 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title">
                        <span class="h3 text-theme sec-subtitle">Testimonials</span>
                        <h2 class="h1">Our Patients Speak</h2>
                        <p>Sharing experiences ... Endorsements from previous and ongoing Patients</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-10 wow fadeIn" data-wow-delay="0.3s">
                    <div class="row vs-carousel" data-slide-show="2">
                        <div class="col-xl-6">
                            <div class="testimonial-box mb-30 bg-white">
                                <div class="content">
                                    <p class="fs-md">The service and facilities at The MEC are of an extremely high quality. I would recommend them without hesitation.</p>
                                </div>
                                <div class="author-img">
                                    <div class="avater-line"></div>
                                    <div class="avater">
                                        <img src="assets/img/author/A2.jpg" alt="Author Image">
                                    </div>
                                </div>
                                <div class="author-info">
                                    <div class="info">
                                        <h3 class="fs-20 name">Malcolm Farnum</h3>
                                        <span class="fs-xs degi text-theme">St. Philip</span>
                                    </div>
                                    <div class="testi-rating">
                                        <div class="star-rating" role="img" aria-label="Rated 5.00 out of 5"><span style="width:100%">Rated <strong class="rating">5.00</strong> out of 5</span></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="testimonial-box mb-30 bg-white">
                                <div class="content">
                                    <p class="fs-md">I really thought that I would have to travel to get this level of treatment but it is available right here in Barbados.</p>
                                </div>
                                <div class="author-img">
                                    <div class="avater-line"></div>
                                    <div class="avater">
                                        <img src="assets/img/author/Au3.jpg" alt="Author Image">
                                    </div>
                                </div>
                                <div class="author-info">
                                    <div class="info">
                                        <h3 class="fs-20 name">Natalie Clarke</h3>
                                        <span class="fs-xs degi text-theme">Christ Church</span>
                                    </div>
                                    <div class="testi-rating">
                                        <div class="star-rating" role="img" aria-label="Rated 5.00 out of 5"><span style="width:100%">Rated <strong class="rating">5.00</strong> out of 5</span></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="testi-shape-img text-center mt-n5 wow fadeInUp" data-wow-delay="0.3s">
            <img src="assets/img/bg/m6.jpg" alt="Image">
        </div>
    </section>
    <!--==============================
    Blog Area
    ==============================-->
    <section class="vs-blog-wrapper space">
        <div class="container">
            <div class="row  text-center justify-content-center">
                <div class="col-md-10 col-lg-8 col-xl-6 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title">
                        <span class="h3 text-theme sec-subtitle">Updates News</span>
                        <h2 class="h1">Latest Posts</h2>
                        The MEC info centre for our new additions and updates.
                    </div>
                </div>
            </div>
            <div class="row vs-carousel wow fadeIn" data-wow-delay="0.3s" data-slide-show="3" data-lg-slide-show="2">
                <div class="col-xl-4">
                    <div class="vs-blog blog-card">
                        <div class="blog-img">
                            <img src="assets/img/blog/p1.jpg" alt="Blog Image" class="w-100">
                            <div class="blog-date">
                                <div class="day">22</div>
                                Jan 2025
                            </div>
                        </div>
                        <div class="blog-content">

                            <h3 class="blog-title h5 font-body lh-base"><a href="index.php">About Our Facilities ...</a></h3>

                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="vs-blog blog-card">
                        <div class="blog-img">
                            <img src="assets/img/blog/p3.jpg" alt="Blog Image" class="w-100">
                            <div class="blog-date">
                                <div class="day">Apr 23</div>
                                2025
                            </div>
                        </div>
                        <div class="blog-content">

                            <h3 class="blog-title h5 font-body lh-base"><a href="index.php">Extended Services ...</a></h3>

                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="vs-blog blog-card">
                        <div class="blog-img">
                            <img src="assets/img/blog/p2.jpg" alt="Blog Image" class="w-100">
                            <div class="blog-date">
                                <div class="day">28</div>
                                Dec 2024
                            </div>
                        </div>
                        <div class="blog-content">

                            <h3 class="blog-title h5 font-body lh-base">Update 1</h3>

                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="vs-blog blog-card">
                        <div class="blog-img">
                            <img src="assets/img/blog/b-1-4.jpg" alt="Blog Image" class="w-100">
                            <div class="blog-date">
                                <div class="day">22</div>
                                Jan 2023
                            </div>
                        </div>
                        <div class="blog-content">
                            <div class="blog-meta">
                                <a href="index.php"><i class="far fa-folder"></i>General Health</a>
                                <a href="index.php"><i class="fal fa-user"></i>David Smith</a>
                            </div>
                            <h3 class="blog-title h5 font-body lh-base"><a href="blog.html">Creation timelines the standard lorem ipsum passage vary</a></h3>
                            <a href="index.php" class="link-btn">Read More<i class="far fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==============================
    Brand Area
    ==============================-->
    <section class="vs-brand-wrapper position-relative  ">
        <div class="icon-shape1 d-none d-xxl-block"><img src="assets/img/icon/icon-1.jpg" alt="Icon"></div>
        <div class="icon-shape2 d-none d-xxl-block"><img src="assets/img/icon/icon-2.png" alt="Icon"></div>
        <div class="container">
            <div class="brand-wrap1" data-bg-src="assets/img/bg/bg-5.jpg">
                <div class="row">
                    <div class="col-md-10 col-lg-8 col-xl-6">
                        <div class="section-title">
                            <span class="h3 text-theme sec-subtitle">Customer Satisfaction</span>
                            <h2 class="h1">We love our Brands</h2>
                            <p>We partner with the best sources to ensure complete Medical Care to the highest standards. Your well-being is our foremost priority.</p>
                        </div>
                    </div>
                </div>
                <div class="row vs-carousel" data-slide-show="5" data-lg-slide-show="4" data-md-slide-show="3" data-sm-slide-show="2">
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/aetna.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/axa.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/barp_logo.jpg" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/bgicy_ic_4c.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/cigna.jpeg" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/guardian.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/icbl.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/metlife.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/sagicor-logo.jpg" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/southgap_hotel.png" alt="Brand Image">
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="brand">
                            <img src="assets/img/mecbrands/yellow_bird_logo.png" alt="Brand Image">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!-- InstanceEndEditable -->









    <!--==============================
    Subscribe Form Area
    ==============================-->
    <div class="vs-newsletter-wrapper space-bottom">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8" data-sec-pos="top-half" data-pos-for=".brand-wrap1">
                    <form action="#" class="form-style1 form-wrap2">
                        <div class="form-group mb-0 d-md-flex text-center text-md-start">
                            <i class="fas fa-envelope text-theme"></i>
                            <input type="text" class="form-control" placeholder="Enter your email address">
                            <button type="submit" class="vs-btn style2 mt-30 mt-md-0"><i class="far fa-long-arrow-right"></i>Subscribe</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--==============================
			Footer Area
	==============================-->
    <footer class="footer-wrapper footer-layout1" data-bg-src="assets/img/bg/bg-shape-4.png">
        <div class="container">
            <div class="footer-top">
                <div class="row align-items-center justify-content-between">
                    <div class="col-sm-6 col-md-auto text-center text-sm-start">
                        <div class="footer1-logo bg-white">
                            <a href="index.php"><img src="assets/img/logo002.png" alt="Logo"></a>
                        </div>
                    </div>
                    <div class=" col-sm-6 col-md-auto pt-20 pt-sm-0 pb-20 pb-sm-0 text-center text-sm-end">
                        <div class="footer-social">
                            <a href="https://www.facebook.com/profile.php?id=61581669345073&rdid=OYDpd1D0FeBaz0AB&share_url=https%3A%2F%2Fwww.facebook.com%2Fshare%2F1A3FkY1oYc%2F" target="_blank" rel="noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
                            <a href="https://www.instagram.com/barbadoscardiologyclinic" target="_blank" rel="noopener noreferrer"><i class="fab fa-instagram-square"></i></a>
                            <a href="https://www.google.com/maps/place/The+MEC+Inc/@13.0970665,-59.6043125,17z/data=!3m1!4b1!4m6!3m5!1s0x8c43f724f78e4141:0xf61061b3fbf77fa4!8m2!3d13.0970665!4d-59.6017322!16s%2Fg%2F11w81z4hfk?entry=ttu&g_ep=EgoyMDI1MTAxNC4wIKXMDSoASAFQAw%3D%3D" target="_blank" rel="noopener noreferrer"><i class="fab fa-google"></i></a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="widget-area">
            <div class="container">
                <div class="row justify-content-between">
                    <div class="col-md-6 col-lg-3 col-xl-3">
                        <div class="widget footer-widget  ">
                            <h3 class="widget_title">About Us</h3>
                            <div class="vs-widget-about">
                                <p>The Medical Emergency Cardiac Centre ... A Hospital where every heart matters</p>


                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-auto col-xl-auto">
                        <div class="widget footer-widget widget_nav_menu   ">
                            <h3 class="widget_title">Services</h3>
                            <div class="menu-all-pages-container">
                                <ul class="menu">
                                    <li><a href="3ser.htm">Cardiac Testing</a></li>
                                    <li><a href="3ser.html">Vascular Surgery</a></li>
                                    <li><a href="3ser.htm">General Care</a></li>
                                    <li><a href="3ser.htm">Stroke Rehab</a></li>
                                    <li><a href="3ser.htm">Coronary Angiogram</a></li>
                                    <li><a href="3ser.htm">Clinical Cardiology</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-md-12  wow fadeInUp" data-wow-delay="600ms">
                        <div class="widget v2 footer-widget time">
                            <h3 class="widget_title-eight">Opening Hours</h3>
                            <div class="vs-widget-shedule">
                                <ul class="footer-shedule">
                                    <li class="one"><span>Mon - Fri:</span>8:00 am - 4:00 pm</li>
                                    <li><span>Saturday:</span>Closed</li>
                                    <li class="one"><span>Sunday:</span>Closed</li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 col-xl-3">
                        <div class="widget footer-widget   ">
                            <h3 class="widget_title">Contact Info</h3>
                            <h4><a class="text-theme hover-white" href="tel:+12466243278"><i class="fas fa-phone-volume me-2 pe-1"></i>+1 (246) 624-3278</a></h4>
                            <div class="address-line">
                                <i class="far fa-map-marker-alt text-theme fs-md"></i>
                                <a href="#" class="text-reset fs-md">#4 6th Avenue Bellville, <br>
                                    St. Michael, Barbados</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="copyright bg-theme">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-auto text-center text-md-end">
                        <p class="mb-0 text-white"> Copyright <script type="text/javascript">
                                document.write(new Date().getFullYear());
                            </script><a class="text-white" href="index.php"> MEC Centre</a> </p>
                    </div>
                    <div class="col-auto d-none d-md-block">
                        <ul class="footer-bottom-menu">
                            <li><a href="#">Privacy</a></li>
                            <li><a href="#">Terms</a></li>
                            <li><a href="6contact.html">Contact</a></li>
                            <li><a href="6wcu.html">About</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </footer>



    <!--********************************
			Code End  Here 
	******************************** -->


    <!-- Scroll To Top -->
    <a href="#" class="scrollToTop scroll-bottom  style2"><i class="fas fa-arrow-alt-up"></i></a>



    <!--==============================
        All Js File
    ============================== -->
    <!-- Jquery -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <!-- Slick Slider -->
    <script src="assets/js/slick.min.js"></script>
    <!-- <script src="assets/js/app.min.js"></script> -->
    <!-- Layerslider -->
    <script src="assets/js/layerslider.utils.js"></script>
    <script src="assets/js/layerslider.transitions.js"></script>
    <script src="assets/js/layerslider.kreaturamedia.jquery.js"></script>
    <!-- Bootstrap -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- jQuery Datepicker -->
    <script src="assets/js/jquery.datetimepicker.min.js"></script>
    <!-- Magnific Popup -->
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <!-- Isotope Filter -->
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <!-- Parallax Scroll -->
    <script src="assets/js/universal-parallax.min.js"></script>
    <!-- WOW Animation -->
    <script src="assets/js/wow.min.js"></script>
    <!-- Custom Carousel -->
    <script src="assets/js/vscustom-carousel.min.js"></script>
    <!-- Form Js -->
    <script src="assets/js/ajax-mail.js"></script>
    <!-- Main Js File -->
    <script src="assets/js/main.js"></script>

</body>

<!-- InstanceEnd -->

</html>