<!DOCTYPE html>
<html lang="{{ config('app.locale', 'en') }}">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>{{ config('app.name', 'Restaurant POS') }}</title>
    <link rel="shortcut icon" href="{{ $fav_icon ?? '' }}" />
    <link href="{{ url(mix('css/app.css')) }}" rel="stylesheet" />
    <link href="{{ url('/css/custom-style.css') }}" rel="stylesheet" />
</head>

<body dir="{{config('app.direction','ltr')}}">
   
   @if(config('app.demo_mode'))
    <div class="bg-pink-600 text-white px-5 py-1 md:flex justify-between items-center shadow-lg space-x-4 text-sm">
        <span>
            <a href="https://codehas.gitbook.io/restaurant-pos-pro" target="_blank" rel="noopener">
                View Documentation
            </a>
        </span>
        <span>Demo mode: data resets every 48 hours.</span>
        <span>
            Report issues: 
            <a href="mailto:info@codehas.net" target="_blank" rel="noopener">info@codehas.net</a> | 
            <a href="mailto:info.codehas@gmail.com" target="_blank" rel="noopener">info.codehas@gmail.com</a>
        </span>
        <span>
            <a href="https://api.whatsapp.com/send/?phone=447394521218&text=Hello,%20I%20need%20help%20with%20Restaurant%20POS%20Pro%20version%20{{ urlencode(config('app.version')) }}" target="_blank" rel="noopener">
                Contact us on WhatsApp
            </a>
        </span>
        <span>Version {{ config('app.version') }}</span>
    </div>
@endif
    <div id="app">
        <div class="fixed left-0 top-0 z-999999 flex h-screen w-screen items-center justify-center bg-white">
            <div class="h-16 w-16 animate-spin rounded-full border-4 border-solid border-cyan-900 border-t-transparent"></div>
        </div>
    </div>
    <script>
        window.app = {!!json_encode($app_data, JSON_THROW_ON_ERROR) !!};
    </script>
    @routes
    <script src="{{ url(mix('js/app.js')) }}"></script>
</body>

</html>
