<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->boolean('bypass_kitchen_bar')->default(false);
            $table->boolean('allow_table_reselect')->default(false);
            $table->boolean('table_is_option')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn('bypass_kitchen_bar');
            $table->dropColumn('allow_table_reselect');
            $table->dropColumn('table_is_option');
        });
    }
};
