<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->unsignedBigInteger('guest_room_reservation_id')->nullable();
            $table->foreign('guest_room_reservation_id')->references('id')->on('guest_room_reservations');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales', function (Blueprint $table) {
            // Drop the foreign key constraint first
            $table->dropForeign(['guest_room_reservation_id']);

            // Then drop the column
            $table->dropColumn('guest_room_reservation_id');
        });
    }
};
