<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('tax_title')->default('Tax');
            $table->boolean('advance_cashbook_mode')->default(true);
            $table->boolean('advance_print_on_submit')->default(true);
            $table->boolean('advance_customer_tip_collection')->default(true);
            $table->boolean('advance_send_notification')->default(false);

            $table->longText('template_order_created')->nullable();
            $table->longText('template_order_cancelled')->nullable();
            $table->longText('template_order_checkout')->nullable();

            $table->boolean('wa_status')->default(false);
            $table->string('wa_twilio_account_sid')->nullable();
            $table->string('wa_twilio_auth_token')->nullable();
            $table->string('wa_twilio_from')->nullable();


            $table->boolean('sms_status')->default(false);
            $table->string('sms_channel')->nullable();

            $table->string('vonage_key')->nullable();
            $table->string('vonage_secret')->nullable();
            $table->string('vonage_from')->nullable();

            $table->string('twilio_account_sid')->nullable();
            $table->string('twilio_auth_token')->nullable();
            $table->string('twilio_from')->nullable();

            $table->string('mysqldump_path')->default('mysqldump');
            $table->boolean('display_logo')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn('tax_title');
            $table->dropColumn('advance_cashbook_mode');
            $table->dropColumn('advance_print_on_submit');
            $table->dropColumn('advance_customer_tip_collection');
            $table->dropColumn('advance_send_notification');

            $table->dropColumn('template_order_created');
            $table->dropColumn('template_order_cancelled');
            $table->dropColumn('template_order_checkout');

            $table->dropColumn('wa_status');
            $table->dropColumn('wa_twilio_account_sid');
            $table->dropColumn('wa_twilio_auth_token');
            $table->dropColumn('wa_twilio_from');


            $table->dropColumn('sms_status');
            $table->dropColumn('sms_channel');

            $table->dropColumn('vonage_key');
            $table->dropColumn('vonage_secret');
            $table->dropColumn('vonage_from');

            $table->dropColumn('twilio_account_sid');
            $table->dropColumn('twilio_auth_token');
            $table->dropColumn('twilio_from');

            $table->dropColumn('mysqldump_path');
            $table->dropColumn('display_logo');
        });
    }
};
