<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SaleItem extends Model
{
    use Filterable, DurationScopeTrait;

    protected $fillable = [
        'sale_id',
        'food_item_id',
        'food_item_attribute_id',
        'food_category_id',
        'item_data',
        'item_name',
        'quantity',
        'price',
        'total_amount',
    ];

    protected $casts = [
        'item_data' => 'json',
    ];

    public function sale(): BelongsTo
    {
        return $this->belongsTo(Sale::class, 'sale_id');
    }

    public function foodItem(): BelongsTo
    {
        return $this->belongsTo(FoodItem::class, 'food_item_id');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(FoodCategory::class, 'food_category_id');
    }
}
