<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class FoodItemAttribute extends Model
{
    use HasFactory;


    protected $fillable = [
        'name',  'food_item_id',
        'sku', 'price', 'cost', 'uuid', 'is_bar_type',
    ];

    public function ingredients(): BelongsToMany
    {
        return $this->belongsToMany(Ingredient::class, 'food_items_ingredients')->withPivot('quantity');
    }
    public function getModifiers()
    {
        return Modifier::get();
    }


    public function foodItem()
    {
        return $this->belongsTo(FoodItem::class);
    }
}
