<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class UserFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return UserFilter
     */
    public function search($search): UserFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('name',  'LIKE', $searchPattern)
            ->orWhere('email',  'LIKE', $searchPattern);
    }
    public function role($role): UserFilter
    {
        return $this->where('role_id', '=', $role);
    }
}
