<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class GuestRoomReservationFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return GuestRoomReservationFilter
     */
    public function search($search): GuestRoomReservationFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('tracking', 'LIKE', $searchPattern);
    }


    public function customer($customer): GuestRoomReservationFilter
    {
        return $this->where('customer_id', '=', $customer);
    }

    public function guestRoom($guestRoom): GuestRoomReservationFilter
    {
        return $this->where('guest_room_id', '==', $guestRoom);
    }

    public function bookingSource($bookingSource): GuestRoomReservationFilter
    {
        return $this->where('booking_source_id', '==', $bookingSource);
    }

    public function reservationStatus($reservationStatus): GuestRoomReservationFilter
    {
        return $this->where('reservation_status_id', '=', $reservationStatus);
    }
}
