<?php

namespace App\Imports;

use App\Models\GuestRoom;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class GuestRoomsImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new GuestRoom([
            'room_name' => $row['room_name'],
            'capactity' => $row['capactity'],
            'per_hour_charges' => $row['per_hour_charges'],
        ]);
    }

    public function rules(): array
    {
        return [
            'room_name' => 'required|unique:guest_rooms,room_name',
        ];
    }
}
