<?php

namespace App\Imports;

use App\Models\BookingSource;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class BookingSourcesImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new BookingSource([
            'title' => $row['title'],
        ]);
    }

    public function rules(): array
    {
        return [
            'title' => 'required|unique:booking_sources,title',
        ];
    }
}
