<?php

namespace App\Http\Resources;

use App\Http\Resources\PosStaffResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ReservationSaleDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'tracking' => $this->tracking,
            'items' => $this->items,
            'created_at' => $this->updated_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
