<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PosTaxResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'tax_title' => $this->tax_title,
            'tax_rate' => $this->tax_rate,
            'is_vat' => $this->is_vat,
            'is_tax_fix' => $this->is_tax_fix,
            //'tax_id' => $this->tax_id ?? null,
            'is_tax_included' => $this->is_tax_included,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
