<?php

namespace App\Http\Resources;

use App\Http\Resources\PosCustomerResource;
use App\Http\Resources\PosPickupPointResource;
use App\Http\Resources\PosServiceTableResource;
use Illuminate\Http\Resources\Json\JsonResource;

class PosBillingSaleOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer_id' => $this->customer_id,
            'items' => $this->items,
            'cart_total_price' => $this->cart_total_price,
            'cart_total_cost' => $this->cart_total_cost,
            'payable_after_all' => $this->payable_after_all,
            'discount_rate' => $this->discount_rate,
            'is_discount_in_percentage' => $this->is_discount_in_percentage,
            'discount_amount' => $this->discount_amount,
            'service_table' => new PosServiceTableResource($this->serviceTable),
            'customer' => new PosCustomerResource($this->customer),
            'order_type' => $this->order_type,
            'recipient_amount' => 0,
            'payment_method_id' => $this->payment_method_id ?? 1,
            'pickup_point' => new PosPickupPointResource($this->pickupPoint),
            'guest_room_reservation' => new PosGuestRoomReservationResource($this->guestRoomReservation),
            'guest_room_reservation_id' => $this->guest_room_reservation_id,
            'tax' => $this->tax,
            'tip_amount' => $this->tip_amount,
            'shipping_address' => $this->shipping_address,
            'tax_amount' => $this->tax_amount,
            'progress' => $this->progress,
            'payment_note' => $this->payment_note,
            'staff_note' => $this->staff_note,
            'note_for_chef' => $this->note_for_chef,
            'took_at' => $this->took_at,
            'prepared_at' => $this->prepared_at,
            'chef_id' => $this->chef_id,
            'order_taker_id' => $this->order_taker_id,
            'is_item_based_taxation' => $this->is_item_based_taxation,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
