<?php

namespace App\Http\Resources;

use App\Http\Resources\FoodCategoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class LastSoldFooditemsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'item_name' => $this->item_name,
            'price' => $this->price,
            'quantity' => $this->quantity,
            'total_amount' => $this->total_amount,
            'category' => new FoodCategoryResource($this->category),
            'image' => $this->foodItem->getImage(),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
