<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SMSGatewayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'sms_status' => 'required',
            'sms_channel' => 'sometimes',
        ];
        if (request('sms_status') && request('sms_channel') == 'nexmo') {
            $rules['vonage_key'] = 'required';
            $rules['vonage_secret'] = 'required';
            $rules['vonage_from'] = 'required';
        }
        if (request('sms_status') && request('sms_channel') == 'twilio') {
            $rules['twilio_account_sid'] = 'required';
            $rules['twilio_auth_token'] = 'required';
            $rules['twilio_from'] = 'required';
        }
        return $rules;
    }
}
