<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ExpenseUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:expenses,title,' . $this->expense->id,
            'amount' => 'required',
            'expense_type_id' => 'required',
            'description' => 'sometimes',
            'expense_date' => 'nullable',
        ];
    }
}
